/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.mteg.crafting;

import com.google.common.collect.ImmutableList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import ttv.migami.jeg.crafting.ScrapWorkbenchIngredient;
import ttv.migami.jeg.util.InventoryUtil;
import ttv.migami.mteg.blockentity.MoWorkbenchBlockEntity;
import ttv.migami.mteg.init.ModRecipeSerializers;
import ttv.migami.mteg.init.ModRecipeTypes;

public class MoWorkbenchRecipe
implements Recipe<MoWorkbenchBlockEntity> {
    private final ResourceLocation id;
    private final ItemStack item;
    private final ImmutableList<ScrapWorkbenchIngredient> materials;

    public MoWorkbenchRecipe(ResourceLocation id, ItemStack item, ImmutableList<ScrapWorkbenchIngredient> materials) {
        this.id = id;
        this.item = item;
        this.materials = materials;
    }

    public ItemStack getItem() {
        return this.item.m_41777_();
    }

    public ImmutableList<ScrapWorkbenchIngredient> getMaterials() {
        return this.materials;
    }

    public boolean matches(MoWorkbenchBlockEntity inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(MoWorkbenchBlockEntity entity) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.item.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.MO_WORKBENCH.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.MO_WORKBENCH.get();
    }

    public boolean hasMaterials(Player player) {
        for (ScrapWorkbenchIngredient ingredient : this.getMaterials()) {
            if (InventoryUtil.hasWorkstationIngredient((Player)player, (ScrapWorkbenchIngredient)ingredient)) continue;
            return false;
        }
        return true;
    }

    public void consumeMaterials(Player player) {
        for (ScrapWorkbenchIngredient ingredient : this.getMaterials()) {
            InventoryUtil.removeWorkstationIngredient((Player)player, (ScrapWorkbenchIngredient)ingredient);
        }
    }
}

